<?php

namespace Drupal\ai_agents\Artifact;

/**
 * Represents a tool artifact in the AI agent system.
 *
 * Artifacts are used to store and reference data generated by AI tools.
 */
class Artifact implements ArtifactInterface {

  /**
   * Constructs a new Artifact instance.
   *
   * @param string $toolId
   *   The ID of the tool that created this artifact.
   * @param int $index
   *   The incremental index for this tool.
   * @param mixed $value
   *   The value stored in the artifact.
   * @param int $timestamp
   *   The UNIX timestamp of when the artifact was created.
   */
  public function __construct(
    protected readonly string $toolId,
    protected readonly int $index,
    protected readonly mixed $value,
    protected readonly int $timestamp,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function getToolId(): string {
    return $this->toolId;
  }

  /**
   * {@inheritdoc}
   */
  public function getIndex(): int {
    return $this->index;
  }

  /**
   * {@inheritdoc}
   */
  public function getValue(): mixed {
    return $this->value;
  }

  /**
   * {@inheritdoc}
   */
  public function getTimestamp(): int {
    return $this->timestamp;
  }

  /**
   * {@inheritdoc}
   */
  public function getPlaceholder(): string {
    return "{{artifact:$this->toolId:$this->index}}";
  }

  /**
   * {@inheritdoc}
   */
  public function __toString(): string {
    return $this->getPlaceholder();
  }

  /**
   * {@inheritdoc}
   */
  public function jsonSerialize(): mixed {
    return [
      'tool_id' => $this->toolId,
      'index' => $this->index,
      'value' => $this->value,
      'timestamp' => $this->timestamp,
    ];
  }

}
