<?php
// phpcs:ignoreFile
/**
 * @file
 * A database agnostic dump for testing purposes.
 *
 * This file was generated by the Drupal 9.2.6 db-tools.php script.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();

$connection->schema()->createTable('file_managed', array(
  'fields' => array(
    'fid' => array(
      'type' => 'serial',
      'not null' => TRUE,
      'size' => 'normal',
      'unsigned' => TRUE,
    ),
    'uid' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'filename' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'uri' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filemime' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '255',
      'default' => '',
    ),
    'filesize' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'big',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'status' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'tiny',
      'default' => '0',
    ),
    'timestamp' => array(
      'type' => 'int',
      'not null' => TRUE,
      'size' => 'normal',
      'default' => '0',
      'unsigned' => TRUE,
    ),
    'type' => array(
      'type' => 'varchar',
      'not null' => TRUE,
      'length' => '50',
      'default' => 'undefined',
    ),
  ),
  'primary key' => array(
    'fid',
  ),
  'unique keys' => array(
    'uri' => array(
      'uri',
    ),
  ),
  'indexes' => array(
    'uid' => array(
      'uid',
    ),
    'status' => array(
      'status',
    ),
    'timestamp' => array(
      'timestamp',
    ),
    'file_type' => array(
      'type',
    ),
  ),
  'mysql_character_set' => 'utf8mb3',
));

$connection->insert('file_managed')
->fields(array(
  'fid',
  'uid',
  'filename',
  'uri',
  'filemime',
  'filesize',
  'status',
  'timestamp',
  'type',
))
->values(array(
  'fid' => '3',
  'uid' => '1',
  'filename' => 'test.jpg',
  'uri' => 'public://2022-03/test.jpg',
  'filemime' => 'image/jpeg',
  'filesize' => '497845',
  'status' => '1',
  'timestamp' => '1647855761',
  'type' => 'image',
))
->values(array(
  'fid' => '17',
  'uid' => '1',
  'filename' => 'test_0.jpg',
  'uri' => 'public://2022-03/test_0.jpg',
  'filemime' => 'image/jpeg',
  'filesize' => '497845',
  'status' => '1',
  'timestamp' => '1647939125',
  'type' => 'image',
))
->execute();
