import Splide from '@splidejs/splide';
import '@splidejs/splide/css'; // import core CSS

document.addEventListener('DOMContentLoaded', () => {
  const sliders = document.querySelectorAll('.splide');

  if (sliders.length) {
    sliders.forEach((sliderEl) => {
      const splide = new Splide(sliderEl, {
        type: 'loop',
        autoplay: false,
        interval: 5000,
        perPage: 1,
        gap: '1rem',
        arrows: true,
        pagination: true,
      });
      splide.mount();
    });

    console.log(`✅ Initialized ${sliders.length} Splide slider(s)`);
  } else {
    console.warn('⚠️ No .splide elements found');
  }
});

(function (Drupal) {
  Drupal.behaviors.videoPopup = {
    attach(context) {
      const modal = document.getElementById('videoModal');
      const iframe = document.getElementById('modalVideoFrame');
      const closeBtn = document.getElementById('closeVideoModal');

      context.querySelectorAll('.custom-popup').forEach(el => {
        el.addEventListener('click', () => {
          let videoUrl = el.getAttribute('data-video-url')?.trim();

          // Convert YouTube watch URLs into embed format
          // ex: https://www.youtube.com/watch?v=lc0QwfbXqsU --> https://www.youtube.com/embed/lc0QwfbXqsU
          if (videoUrl.includes('watch?v=')) {
            const id = videoUrl.split('v=')[1].split('&')[0];
            videoUrl = `https://www.youtube.com/embed/${id}`;
          }

          iframe.src = videoUrl;
          modal.classList.remove('hidden');
        });
      });

      if (closeBtn) {
        closeBtn.addEventListener('click', () => {
          iframe.src = '';
          modal.classList.add('hidden');
        });
      }

      if (modal) {
        modal.addEventListener('click', (e) => {
          if (e.target === modal) {
            iframe.src = '';
            modal.classList.add('hidden');
          }
        });
      }
    }
  };
})(Drupal);


