/** @type {import('tailwindcss').Config} */
module.exports = {
  content: [
    "./templates/**/*.{html,twig}",
    "../../../modules/custom/**/*.{html,twig}",
    "../../../themes/custom/**/*.{html,twig}",
    "../../../**/*.html",          // Include rendered Drupal HTML
    "../../../**/*.twig",        // Include rendered Drupal Twig templates
  ],
  safelist: [
    'text-2xl',
    'text-3xl',
    'text-4xl',
    'lg:text-4xl',
    'lg:text-6xl',
    'font-bold',
    'text-center',
    'leading-tight',
    'text-balance',
    'text-primary',
    'bg-primary/10',
    'bg-primary/50',
    'bg-primary/80',
    'grid',
    'grid-cols-3',
    'gap-6',
    'gap-8',
    'px-6',
    'p-6',
    'p-8',
    'md:p-12',
    'space-y-4',
    'py-6',
    'py-4',
    'pt-8',
    'mb-4',
    'border',
    'border-t',
    'border-border',
    'text-card-foreground',
    'text-muted-foreground', 
    'text-sm',
    'flex',
    'flex-col',
    'flex',
    'justify-between',
    'inline-flex',
    'items-center',
    'justify-center',
    'rounded-md', 
    'rounded-xl',
    'rounded-t-lg',
    'shadow-sm',
    'bg-card',
    'hover:shadow-xl',
    'transition-all',
    'duration-300',
    'group',
    'relative',
    'overflow-hidden',
    'w-full',
    'h-48', 
    'object-cover',
    'group-hover:scale-105',
    'transition-transform',
    'px-2','py-0.5',
    'text-xs',
    'font-medium',
    'w-fit',
    'whitespace-nowrap',
    'shrink-0', '[&>svg]:size-3', 'gap-1',
    '[&>svg]:pointer-events-none', 
    'focus-visible:ring-ring/50', 'focus-visible:ring-[3px]', 'aria-invalid:ring-destructive/20', 'dark:aria-invalid:ring-destructive/40', 'aria-invalid:border-destructive', 'transition-[color,box-shadow]', 'border-transparent', 'absolute', 'top-4', 'left-4', 'bg-primary', 'text-primary-foreground',
    '@container/card-header', 'auto-rows-min', 'grid-rows-[auto_auto]', 'items-start', 'gap-1.5', 'has-data-[slot=card-action]:grid-cols-[1fr_auto]', '[.border-b]:pb-6',
    'text-lg', 
    'text-pretty',
    'max-w-3xl',
    'max-w-2xl',
    'mx-auto',
    'disabled:pointer-events-none',
    'disabled:opacity-50',
    '[&_svg]:pointer-events-none',
    'cursor-pointer',
    '[&_svg]:shrink-0',
    'outline-none',
    'focus-visible:border-ring',
    'bg-primary',
    'bg-primary/90',
    'shadow-xs',
    'hover:bg-primary/90',
    'h-9',
    'px-4',
    'py-2',
    'has-[>svg]:px-3',
    'bg-gradient-to-r',
    'from-purple-500',
    'to-pink-500',
    'hover:from-purple-600',
    'hover:to-pink-600',
    'text-white',
    'gap-2',
    'md:flex-row',
    'flex-shrink-0',
    'w-20',
    'h-20',
    'rounded-full',
    'flex-1',
    'md:text-left',
    'mb-6',
    'font-semibold',
    'text-xl',
    'text-gray-600',
    'bg-white',
    'rounded-lg',
    'shadow-md',
    'shadow-none',
    'text-emerald-600',
    'text-blue-600',
    'text-purple-600','shadow-lg', 'hover:shadow-xl', 'transition-shadow',
    'top-4', 'right-4',
    '[&amp;&gt;svg]:size-3', '[&amp;&gt;svg]:pointer-events-none',
    '[a&amp;]:hover:bg-primary/90',
     'bg-emerald-500', 'hover:bg-emerald-600',
    'w-8','h-8','bg-emerald-600', 'hover:bg-emerald-700',
    'mt-16','bg-gradient-to-r', 'from-emerald-50', 'to-blue-50', 'rounded-2xl',
    'hover:shadow-lg',
    'w-16', 'h-16',
    'w-md', 'w-lg', 'w-xl',
    'max-w-md',
    'mb-2',
    'max-w-4xl',
    'md:grid-cols-2',
    'lg:grid-cols-4',
    'gap-8',
    '-top-3', '-right-3','bg-black',
    'basis-full', 'md:basis-1/2', 'lg:basis-1/4',

  ],
  theme: {
    extend: {
      fontFamily: {
        sans: ['Inter', 'ui-sans-serif', 'system-ui'],
      },
      colors: {
        primary: '#7ec468', // <-- Add your brand color here
        'primary-foreground' : '#ffffff',
        card: "oklch(var(--card))",
        "card-foreground": "oklch(var(--card-foreground))",
        secondary: "oklch(var(--secondary))",
        "secondary-foreground": "oklch(var(--secondary-foreground))",
        muted: "oklch(var(--muted))",
        "muted-foreground": "oklch(var(--muted-foreground))",
        accent: "oklch(var(--accent))",
        "accent-foreground": "oklch(var(--accent-foreground))",
        destructive: "oklch(var(--destructive))",
        "destructive-foreground": "oklch(var(--destructive-foreground))",
        border: "oklch(var(--border)",
        input: "oklch(var(--input))",
        ring: "oklch(var(--ring))",
        sidebar: "oklch(var(--sidebar))",
        "sidebar-foreground": "oklch(var(--sidebar-foreground))",
        "sidebar-primary": "oklch(var(--sidebar-primary))",
        "sidebar-primary-foreground": "oklch(var(--sidebar-primary-foreground))",
        "sidebar-accent": "oklch(var(--sidebar-accent))",
        "sidebar-accent-foreground": "oklch(var(--sidebar-accent-foreground))",
        "sidebar-border": "oklch(var(--sidebar-border))",
        "sidebar-ring": "oklch(var(--sidebar-ring))",
      },
      borderRadius: {
        lg: "var(--radius)",
      },
    },
  },
  plugins: [],
}
